%% function to compare the results of TransFun with another point cloud
% and give the error. The points are hard-coded into the script to allow
% optimisation.
% the error is the average difference of the transformed vals2 minus vals1
%
% Alisdair R. MacLeod
% University of Bath, 2015
%
%
function transerr = Trans_Err_2_5pts_sc(trans)
%
%% *** NOTE - THIS MUST BE MANUALLY EDITED FOR EACH NEW DATA SET ***
%% point to align to
vals1=[89.4570061943793,-141.656704646452,261.281230323166;92.4184790885072,-144.110117667672,283.363627525637;45.9423447949191,-108.496906812343,322.654828768518;122.961814875704,-116.944619934303,308.657557886052;86.0990416343601,-90.7591247200814,314.942324823616];
%% opensim points
vals2=[  -30.3000  -70.7000    8.4000
  -33.7595  -44.8196    7.9005
   -2.2138  -11.4460  -40.9443
    1.7777  -12.3343   38.8444
   22.5742  -13.7862    1.2842];
% %% use the scale factor to initially scale all of the points (before transform)
% % X scale
% vals2(:,1)=vals2(:,1)*trans(7);
% % Y scale
% vals2(:,2)=vals2(:,2)*trans(8);
% % Z scale
% vals2(:,3)=vals2(:,3)*trans(9);
%% Execute rotation from randomly generated values
transvals=TransFun_sc(vals2,trans);
%% Evaluate the error versus the alignment points
transerr = abs(transvals) - abs(vals1);
%% Save the errors
[b,c]=size(transerr);
transerr = reshape (transerr,[b*c,1]);
%
% transerr1 = mean(abs(transerr(:,1)));
% transerr2 = mean(abs(transerr(:,2)));
% transerr3 = mean(abs(transerr(:,3)));
% 
% get means for each direction
%transerr = mean(abs(transerr));
% get mean value of error overall
%transerr = mean(abs(transerr));
end